within AixLib.Airflow.Multizone.Examples;
model OneEffectiveAirLeakageArea "Model with an effective air leakage area"
  extends Modelica.Icons.Example;
  package Medium = AixLib.Media.Air;

  AixLib.Fluid.MixingVolumes.MixingVolume volA(
    redeclare package Medium = Medium,
    V=2.5*5*5,
    nPorts=2,
    energyDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial,
    massDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial,
    m_flow_nominal=0.01)
    annotation (Placement(transformation(extent={{20,-20},{40,0}})));
  AixLib.Fluid.MixingVolumes.MixingVolume volB(
    redeclare package Medium = Medium,
    V=2.5*5*5,
    nPorts=1,
    energyDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial,
    massDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial,
    m_flow_nominal=0.01)
    annotation (Placement(transformation(extent={{70,20},{90,40}})));
  Modelica.Thermal.HeatTransfer.Sources.PrescribedHeatFlow preHeaFlo
    annotation (Placement(transformation(extent={{0,20},{20,40}})));
  Modelica.Blocks.Sources.Sine Sine1(freqHz=1/3600) annotation (Placement(
        transformation(extent={{-80,20},{-60,40}})));
  Modelica.Blocks.Math.Gain Gain1(k=100) annotation (Placement(transformation(
          extent={{-40,20},{-20,40}})));
  AixLib.Airflow.Multizone.EffectiveAirLeakageArea cra(redeclare package
      Medium = Medium, L=20E-4)
    annotation (Placement(transformation(extent={{50,-40},{70,-20}})));
  AixLib.Fluid.Sources.MassFlowSource_T sou(
    redeclare package Medium = Medium,
    nPorts=1,
    use_m_flow_in=true)
    annotation (Placement(transformation(extent={{-20,-40},{0,-20}})));
  Modelica.Blocks.Sources.Ramp ramSou(
    duration=3600,
    height=0.01,
    offset=0,
    startTime=1800) annotation (Placement(transformation(extent={{-80,-32},{-60,
            -12}})));
equation
  connect(sou.ports[1], volA.ports[1]) annotation (Line(
      points={{5.55112e-16,-30},{28,-30},{28,-20},{28,-20}},
      color={0,127,255}));
  connect(ramSou.y, sou.m_flow_in) annotation (Line(
      points={{-59,-22},{-20,-22}},
      color={0,0,127}));
  connect(volB.ports[1], cra.port_b) annotation (Line(
      points={{80,20},{80,-30},{70,-30}},
      color={0,127,255}));
  connect(volA.ports[2], cra.port_a) annotation (Line(
      points={{32,-20},{32,-30},{50,-30}},
      color={0,127,255}));
  connect(preHeaFlo.port, volB.heatPort) annotation (Line(
      points={{20,30},{70,30}},
      color={191,0,0}));
  connect(Gain1.y, preHeaFlo.Q_flow) annotation (Line(
      points={{-19,30},{-5.55112e-16,30}},
      color={0,0,127}));
  connect(Gain1.u, Sine1.y) annotation (Line(
      points={{-42,30},{-59,30}},
      color={0,0,127}));
  annotation (__Dymola_Commands(file="modelica://AixLib/Resources/Scripts/Dymola/Airflow/Multizone/Examples/OneEffectiveAirLeakageArea.mos"
        "Simulate and plot"),
        experiment(
      StopTime=7200,
      Tolerance=1e-05),
    Documentation(info="<html>
<p>
This model consists of a model for an effective air leakage area
that is connected to two air volumes.
Air flows due to the addition of air to the volume <code>volA</code>
and because heat is exchanged with <code>volB</code>.
</p>
</html>", revisions="<html>
<ul>
<li>
December 22, 2014 by Michael Wetter:<br/>
Removed <code>Modelica.Fluid.System</code>
to address issue
<a href=\"https://github.com/lbl-srg/modelica-buildings/issues/311\">#311</a>.
</li>
<li>
November 10, 2011, by Michael Wetter:<br/>
Added documentation.
</li>
</ul>
</html>"));
end OneEffectiveAirLeakageArea;
